	function a = REAL_2_TWOC(number, n)
	
	% 	Converts a real number between -1 and 1 to a two's-complement 
	%	number of wordlength n.
	% 	Works properly only when number can be described exactly with n bits, 
	%	i.e., no rounding has been implemented.

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Oscar Gustafsson
	% 	Modified by: 	 	LW 2003-03-11
	%	Copyright:			by authors - not released for commercial use
	% 	Version:			1	 
	% 	Known bugs:			
	% 	Report bugs to:		Wanhammar@gmail.com
	
	while abs(number) > 1
		number = number*2^-1;
	end
	
	if number >=0
		a(1) = 0;	
		for i = 1:n-1
			bit = floor(2*number);
			number = rem(2*number,1);
			a(i+1) = bit;
		end
	else
		a(1) = 0;	
		for i = 1:n-1
			bit = floor(2*abs(number));
			number =  rem(2*abs(number),1);
			a(i+1) = bit;
		end
		j = n;
		pos = 0;
		while pos == 0 & j ~= 0
			if a(j) == 1
				pos = j-1;
			else
				j = j-1;
			end
		end
		for i = 1:pos, a(i) = 1-a(i); end
	end
